<?php
/**
 * Removes directory with all subdirectories and files
 *
 * @param $dirname string - directory to be deleted
 * 
 * @return boolean
 */
function full_rmdir($dirname){
	if ($dirHandle = opendir($dirname)){
		$old_cwd = getcwd();
		chdir($dirname);

		while ($file = readdir($dirHandle)){
			if ($file == '.' || $file == '..') continue;

			if (is_dir($file)){
				if (!full_rmdir($file)) return false;
			}else{
				if (!unlink($file)) return false;
			}
		}

		closedir($dirHandle);
		chdir($old_cwd);
		if (!rmdir($dirname)) return false;
		
		return true;
	}else{
		return false;
	}
}

/**
 * Function extending class phpmailer
 *
 * @param $sender string
 * @param $recipient string
 * @param $subject string
 * @param $body string
 * @param $file string - filename
 * @return boolean
 */
function mail_it($recipient, $subject, $body){
  $mail = new PHPMailer();
  
  $mail->IsSMTP();
  $mail->SMTPAuth   = true;                  // enable SMTP authentication
  $mail->SMTPSecure = "ssl";                 // sets the prefix to the servier
  $mail->Host       = SMTP_HOST;      // sets GMAIL as the SMTP server
  $mail->Port       = 465;                   // set the SMTP port for the GMAIL server
  
  $mail->Username   = SMTP_USERNAME;  // GMAIL username
  $mail->Password   = SMTP_PASSWORD;            // GMAIL password
  $mail->From       = SMTP_USERNAME;
  
  $mail->Subject    = $subject;
  
  $mail->AltBody    = "To view the message, please use an HTML compatible email viewer!"; // optional, comment out and test
  $mail->WordWrap   = 50; // set word wrap
  
  $mail->MsgHTML($body);
  
  $mail->AddAddress($recipient);
  
  $mail->IsHTML(true); // send as HTML
  
  return $mail->Send();
/*
	$mail= new mime_mail(); 
	$mail->from = $sender; 
	$mail->to = $recipient;
	$mail->subject = $subject;
	$mail->body = $body;
	
	If(!empty($file) AND (file_exists($file))){
		$data = file_get_contents($file);
		$finfo = new finfo(FILEINFO_MIME, $file); 
		$type = $finfo->file($file);
		$finfo->close();
		$mail->add_attachment($data, array_reverse(explode("/", $file)), $type);
	}
	
	$r = $mail->send();
	unset($mail);
	return $r;*/
}

/**
 * Class autoloader
 * 
 * Class per file system - each class is different file wich name is name of class
 *
 * @param $class_name 
 */
function __autoload($class_name){
	$filename = '';
	preg_match_all('/([A-Z][a-z0-9]*)/', $class_name, $matches);
	foreach($matches[1] as $part){
		$filename .= '_' . strtolower($part);
	}
	$filename = substr($filename, 1);
	require_once DIRECTORY_CLASSES . "/{$filename}.php";
}

/**
 * Returns actual time in given format
 *
 * @param $format string [optional] - default = 'H:i:s - d. m. Y'
 * @param $addon string [optional] - string to be appended to the end of result, e. g. ' - '
 * 
 * @return string 
 */
function dtnow($format = '',  $addon = false) {
	Switch ($format){
		case 'error':
			$format = 'Y-m-d - H:i:s'; 
			$addon = ($addon === false) ? '' : $addon;
			break;
		case 'backup':
			$format = 'Y-m-d~~H-i-s'; 
			break;
		default:
			$format = 'H:i:s - d. m. Y'; 
			break;
	}
    return date($format) . $addon;
}

/**
 * Checks if directory exists, if not, creates it
 *
 * @param $dir string
 * @return boolean
 */
function check_dir($dir){
	$dirs = array();
	$ar = explode('/', $dir);
	foreach($ar as $key => $value){
		$d = '';
		$k = 0;
		while ($key >= 0){
			$d .= '/' . $ar[$k];
			$key--;
			$k++;
		}
		$d = ltrim($d, '/');
		if(!is_dir($d)){
			if(!mkdir($d)) {return FALSE;}
		}
	}
	return TRUE;
}

/**
 * Generates random character or number
 * 
 * @param length [optional] - default = 1
 * @return string
 */
function randomchar($length = 1){ 
	$rletter = '';
	$rletter .= chr(rand(48, 57)); // random number
	$rletter .= chr(rand(65, 90)); // random upper char
	$rletter .= chr(rand(97, 122)); // random lower char
	return $rletter{rand(0, 2)}; // select random letter of generated letters
}

/**
 * Generates random colour, with a respect to image background
 *
 * @param $img image resource
 * @param $bg string background - 'black' or 'white'
 * @return int - a color identifier representing the color composed of random RGP components
 */
function randomcolor($img, $bg){
	switch ($bg){
		case 'black':
			return imagecolorallocate($img, rand(100,255), rand(100,255), rand(100,255));
			break;
		case 'white':
			return imagecolorallocate($img, rand(0,150), rand(0,150), rand(0,150));
			break;
		default:
			return imagecolorallocate($img, rand(0,255), rand(0,255), rand(0,255));	
			break;
	}
}

/**
 * Compute seconds value for given interval. Accepts years (Y), quartals (Q), months (M), weeks (W), days (D), hours (H), minutes (I), seconds (S).
 *
 * @param $interval string = for example = '12 D'
 * @param $exact boolean [optional] = Whether count with year as 365.25 (TRUE) or 365 (FALSE) days long
 * @return integer - seconds
 */
function interval_to_seconds($interval, $exact = TRUE){
	if((bool) $exact) {
		$year = 365.25 * 24 * 60 * 60;
	} else {
		$year = 365 * 24 * 60 * 60;
	}
	
	$value = (float) rtrim($interval, ' YQMWDHIS');
	$seconds = 0;
	
	switch(substr($interval, -1)){
		case 'Y':
			$seconds = $value * $year;
			break;
		case 'Q':
			$seconds = $value * ($year / 4);
			break;
		case 'M':
			$seconds = $value * ($year / 12);
			break;
		case 'W':
			$seconds = $value * 60 * 60 * 24 * 7;
			break;
		case 'D':
			$seconds = $value * 60 * 60 * 24;
			break;
		case 'H':
			$seconds = $value * 60 * 60;
			break;
		case 'I':
			$seconds = $value * 60;
			break;
		case 'S':
			$seconds = $value;
			break;
	}
	
	return round($seconds);
}

/**
 * Error handler - uses class error_handler
 *
 * @param $error_number
 * @param $error_text
 * @param $file
 * @param $line
 */
function error_handler($error_number, $error_text, $file, $line, $error_context){
  if(defined('DEBUG') AND DEBUG) {
    vd("ERROR: #$error_number: $error_text<br /> in $file on line $line");
  } else {
    return ErrorHandler::get_instance()->log_it($error_number, $error_text, $file, $line, $error_context);
  }
}

/**
 * Deletes all files in directory if older then given period of time. Age is determined by applying callback function.
 *
 * @param $directory string
 * @param $age string - used by function interval_to_seconds
 * @param $check_function string - callback function
 * @return boolean
 */
function delete_old($directory, $age, $check_function = 'filemtime'){
	if(!function_exists($check_function)){
		$err = "Call to undefined function '{$check_function}' by function 'delete_old'.";
		trigger_error($err, E_USER_WARNING);
		return FALSE;
	}
	
	$del_files = array();
	$dir = dir($directory);
	while(($file = $dir->read()) !== FALSE){
		if(!is_dir($file)){
			$r = call_user_func($check_function, $file);
			if(($r !== FALSE) AND ($r < (time() - interval_to_seconds($this->frequency_of_refresh)))){
				$del_files[] = $file;
			}
		}
	}
	
	if(!empty($del_files)){
		foreach ($del_files as $key => $value){
			$del_files[$key] = unlink($value);
		}
	}
	
	if(in_array(FALSE, $del_files)){
		return FALSE;
	} else {
		return TRUE;
	}
}

/**
 * Parses preformated var_dump of given parameter
 * @param mixed $mixed
 * @param array $formatting - array of css style formatting
 * @return string
 */
function vds($mixed, $formatting = array()){
	ob_start();
	var_dump($mixed);
	$ret = "<pre style='display: block; float: none; clear: both; background-color: #000059; color: silver; word-spacing: 5px; line-height: 1.7; padding: 15px;";
	foreach($formatting as $key => $value){
		$ret .= " {$key}: {$value};";
	}
	$ret .= "'>\r\n" . str_ireplace("=>\n", ' =>', ob_get_contents()) . "</pre>\r\n";
	ob_end_clean();
	return $ret;
}

/**
 * Outputs preformated return of vds()
 * @param mixed $mixed
 * @param array $formatting - array of css style formatting
 * @return void
 */
function vd($mixed, $formatting = array()){
	echo vds($mixed, $formatting);
}

/**
 * Converts boolean to string
 * @param boolean $var
 * @return string
 */
function bool2str($var){
	if (is_bool($var)){
		return ($var) ? 'true' : 'false';
	}
}

/**
 * Appends given data to file
 * @param string $filename
 * @param string $data
 * @return boolean
 */
function file_append($filename, $data){
	$ret = true;
	$file = fopen($filename, 'a');
	if($file === false) return false;
	if(flock($file, LOCK_EX)){
		fwrite($file, $data);
		if(!flock($file, LOCK_UN)) $ret = false;
	} else {
		$ret = false;
	}
	if(!fclose($file)) $ret = false;
	return $ret;
}


/** 
 * Determines (approximate) maximum file size for uploads
 * @return integer
 */
function get_max_upload_filesize(){
  $ini_umf = ini_get('upload_max_filesize');
  $ini_pmf = ini_get('post_max_size');
  
  $result = '';
  if($ini_umf != '') {
    if($result == '') $result = get_bytes($ini_umf);
    else $result = min($result, get_bytes($ini_umf));
  }
  if($ini_pmf != '') {
    if($result == '') $result = get_bytes($ini_pmf);
    else $result = min($result, get_bytes($ini_pmf));
  }
  return $result;
}
  
/**
 * Converts shorthand byte value to bytes
 * @see http://www.php.net/manual/en/faq.using.php#faq.using.shorthandbytes
 * @param string $val
 * @return int
 */ 
function get_bytes($val) {
  $val = trim($val);
  if($val == '') return 0;
  
  switch(strtolower($val[strlen($val)-1])) {
    case 'g': $val *= 1024;
    case 'm': $val *= 1024;
    case 'k': $val *= 1024;
  }

  return $val;
}

/**
 * Converts bytes to shorthand byte value
 * @see http://www.php.net/manual/en/faq.using.php#faq.using.shorthandbytes
 * @param int $bytes
 * @param int $decimals - number of decimal points 
 * @return string
 */ 
function get_shorthand_bytes($bytes, $decimals) {
  $trans = array('B', 'K', 'M', 'G', 'T');
  
  for($i = 0; $i < count($trans); $i++){
    $unit = $trans[$i];
    if($i == count($trans)-1) break;
    
    if ($bytes >= 1024) {
      $bytes /= 1024;
    } else {
      break;
    }
  }
  
  return round($bytes, $decimals) . $unit;
}
?>